#include <Wire.h>
#include <RTC_Semesin.h>

RTC_DS3231 rtc;

char bulanStr[12][4] = {"JAN", "FEB", "MAR", "APR", "MEI", "JUN", "JUL", "AGS", "SEP", "OKT", "NOP", "DES"};
char hariStr[7][4] = {"MIN", "SEN", "SEL", "RAB", "KAM", "JUM", "SAB"};

DateTime now;
char buffer[32];
byte detikSebelumnya;

void setup () {

#ifndef ESP8266
  while (!Serial); // for Leonardo/Micro/Zero
#endif

  Serial.begin(9600);

  rtc.begin();

  if (rtc.lostPower()) {
    rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
  }
}

void loop () {
  now = rtc.now();
  if (detikSebelumnya != now.detik)
  {
    sprintf(buffer, "%s %02d %s %02d", hariStr[now.hari - 1], now.tanggal, bulanStr[now.bulan], now.tahun - 2000);
    sprintf(buffer, "%s %02d-%02d-%02d", hariStr[now.hari - 1], now.tanggal, now.bulan, now.tahun - 2000);
    sprintf(buffer, "%02d-%02d-%02d", now.tanggal, now.bulan, now.tahun - 2000);
    sprintf(buffer, "%02d:%02d:%02d", now.jam, now.menit, now.detik);
    sprintf(buffer, "%s %02d %s %02d   %02d:%02d", hariStr[now.hari - 1], now.tanggal, bulanStr[now.bulan], now.tahun - 2000, now.jam, now.menit);
    Serial.print(buffer);
  }

}
